<?php 

define('H', $_SERVER['DOCUMENT_ROOT'] . '/');

require H.'sys/inc/start.php';
require H.'sys/inc/sess.php';
require H.'sys/inc/settings.php';
require H.'sys/inc/db_connect.php';
require H.'sys/inc/ipua.php';
require H.'sys/inc/fnc.php';

$classDiary = new Diary();

require 'config.php';

require H.'sys/inc/user.php';

if (isset($_GET['f']) && preg_match('#^([A-z0-9\.]+)$#i', $_GET['f'])) {
  if (is_file('inc/' . $_GET['f'] . '.php')) {
    $maps['f'] = $_GET['f'];
  }
}

$user_id = 0;

if (isset($user)) {
    $user_id = $user['id'];
}

$maps['r'] = $tools->keyGlobals('r', 'get', 'index');
$maps['u'] = (int) $tools->keyGlobals('u', 'get', null);
$maps['diary_id'] = $tools->keyGlobals('id', 'get', 0);
$maps['page'] = $tools->keyGlobals('page', 'get', 1);
$maps['s'] = $tools->keyGlobals('s', 'get', 'n');

if ($maps['s'] == 'u' && $maps['u']) {
  $nameSort['u'] = user::nick($maps['u'], 0);
}

$maps['zsort'] = $tools->keyGlobals('zsort', 'get', '1');

if ($maps['zsort'] == '1') {
  $zsort = 'DESC';
} else {
  $zsort = 'ASC';
}

if (!preg_match('/[a-z]/', $maps['s'])) {
  $maps['s'] = 'n';
}

$maps['search'] = $tools->keyGlobals('q', 'get', null);

$querySearch = my_esc($maps['search']);
$maps['search'] = text($maps['search']);

if (isset($user)) 
{   
    if (isset($_GET['like'])) {
        $act = $classDiary->get_like($maps['diary_id'], $user['id'], $_GET['like']);
    } elseif (isset($_POST['msg']) && isset($_POST['comment'])) {
        $act = $classDiary->get_comment($maps['diary_id'], $user['id'], $_POST['msg'], isset($_POST['reply']) ? $_POST['reply'] : 0);
    } elseif (isset($_POST['access'])) {
        $act_key = isset($_POST['private']) ? 'private' : 'private_komm';
        
        $act = $classDiary->get_edit_access($maps['diary_id'], $act_key, $_POST[$act_key]);
    } elseif (isset($_POST['diary_create'])) {
        $edit_id = $maps['diary_id'];
        $data = array(
            'name' => $tools->keyGlobals('name', 'post', NULL),
            'msg' => $tools->keyGlobals('msg', 'post', NULL),
            'private' => $tools->keyGlobals('diary_access', 'sess', 0),
            'private_komm' => $tools->keyGlobals('diary_comment', 'sess', 0),
            'attachments' => 0,
        );
        
        $act = $classDiary->get_edit($edit_id, $user_id, $data);
    } elseif (isset($_POST['diary_access']) || isset($_POST['diary_comment'])) {
        
        $_SESSION['diary_message'] = $tools->keyGlobals('msg', 'post', NULL);
        $_SESSION['diary_name'] = $tools->keyGlobals('name', 'post', NULL);
        
        if ($maps['f'] != 'access') {
            header('Location: ?f=access&s=u&r=' . $maps['r'] . '&u='. $user_id .'&id=' . $maps['diary_id'] . '&act=edit&edit=' . 
                                          (isset($_POST['diary_comment']) ? 'comment' : 'view'));
            exit;
        }
        
        $act = $classDiary->get_edit_access($maps['diary_id'], $act_key, $_POST[$act_key]);
    } elseif (isset($_POST['diary_attach'])) {
        $_SESSION['diary_name'] = $tools->keyGlobals('name', 'post', NULL);
        $_SESSION['diary_message'] = $tools->keyGlobals('msg', 'post', NULL);
        
        $_SESSION['diary']['return'] = $_SERVER['REQUEST_URI'];
        header('Location: /user/attachments/?location=diary');
        exit;
    } elseif (isset($_POST['delete'])) {
        $delete_type = $tools->keyGlobals('type', 'post', 0);
        $delete_id = $tools->keyGlobals('delete_id', 'post', 0);
        
        $act = $classDiary->get_delete($delete_type, $delete_id);
    }
    
    if (isset($act)) {
        if (isset($act['msg'])) {
            $_SESSION['message'] = $act['msg'];
        }
        
        if (isset($act['success'])) {
            if (isset($act['maps'])) {
                $maps = array_merge($maps, $act['maps']);
            }
            
            header('Location: ?f='. $maps['r'] .'&s='. $maps['s'] .'&q='. $maps['search'] .'&r='. $maps['f'] .'&u='. $maps['u'] .'&id='. $maps['diary_id'] .'&zsort='. $maps['zsort'] .'&page='. $maps['page']);
            exit;
        }
        
        if (isset($act['error'])) {
            $err = $act['error'];
        }
    }    
}



require 'inc/' . $maps['f'] . '.php';

require H.'sys/inc/tfoot.php';